﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="QuotationDetails.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Sales.Quotations.QuotationDetails" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdQuotationDetailsID" runat="server" />
    <asp:HiddenField ID="hdOrdersID" runat="server" />

    <div class="pageheader">
        <h2>
            <i class="fa fa-file-text"></i>Quotation Details
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Quotations.aspx">Quotations</a></li>
                <li class="active">Quotation Details</li>
            </ol>
        </div>

    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Quotation Details</h1>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView ID="grdOrderDetails" runat="server" CssClass="table"
                    Width="100%" GridLines="Both" AutoGenerateColumns="false">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Product" DataField="ProductName" />
                        <asp:BoundField HeaderText="Unit Price" DataField="UnitPrice" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Quote Price" DataField="OrderPrice" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Qty" DataField="Quantity" />
                        <asp:BoundField HeaderText="Amount" DataField="Amount" DataFormatString="{0:0.00}" />
                        <asp:TemplateField HeaderText="Control">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkEditOrder" runat="server" Text="Edit" CommandArgument='<%# Eval("UniqueID") %>'
                                    OnClick="lnkEditOrder_Click" Visible='<%# (Eval("QuotationsStatus").ToString().ToLower() == "processed" ? false : true) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-row" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>
    <br />
    <br />
    <div class="buttonpanel">
        <asp:Button ID="btnDownLoadQuotation" runat="server" CssClass="btn btn-primary btn-lg"
            Text="Download Quote" OnClick="btnDownLoadQuotation_Click" Visible="false" />
        &nbsp;
                    <asp:HyperLink ID="lnkViewQuotation" runat="server" CssClass=" btn-lg btn btn-primary " Text="View Quote"
                        Visible="false" Target="_blank" />
        &nbsp;
                    <asp:HyperLink ID="HyperLink1" runat="server" CssClass="btn btn-primary btn-lg" Text="Back"
                        NavigateUrl="~/Admin/Sales/Quotations/Quotations.aspx" />
    </div>

    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>

    <div class="modal fade" id="divPaymentStatus" tabindex="-1" role="dialog" aria-labelledby="Payment" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H1">Update Quotation Status</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-xs-12 col-md-12"><asp:Label ID="lblEditError" ForeColor="Red" runat="server"></asp:Label></div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-4">Product Unit Price</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:Label ID="lblProductUnitPrice" runat="server" /></div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-4">Product Unit Price:&nbsp; SGD &nbsp;</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox ID="txtQuotationPrice" runat="server" Width="100px" CssClass="textbox number" /></div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-4">Remarks</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:TextBox ID="txtRemarks" runat="server" Width="300px" CssClass="textbox" Height="200px" TextMode="MultiLine" /></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSave" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSave_Click" />
                    &nbsp;
                   <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                       OnClick="btnCancel_Click" />
                </div>
            </div>
        </div>
    </div>

</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
</asp:Content>
